/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: TextEvent.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.parser;

import java.io.IOException;
import de.kxml.*;

/**
 * A class for events indicating character data like
 * "normal" text or ignorable whitespace.
 */
public class TextEvent extends ParseEvent {
    String text;

    /**
     * Constructor declaration
     *
     *
     * @param text
     *
     * @see
     */
    public TextEvent(String text) {
	this.text = text;
    }

    /**
     * returns the actual character data as String
     */
    public String getText() {
	return text;
    } 

    /**
     * returns Xml.TEXT_EVENT
     */
    public int getType() {
	return Xml.TEXT;
    } 

    /**
     * Method declaration
     *
     *
     * @param start
     *
     * @return
     *
     * @see
     */
    public boolean endCheck(StartTag start) {
	int i = text.length();

	while (i-- > 0) {
	    if (text.charAt(i) > ' ') {
		throw new RuntimeException("unexpected text: '" + text + "'");
	    } 
	}

	return false;
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public String toString() {
	return text;
    } 

}

